% Generated by roxygen2 (4.0.1): do not edit by hand
\docType{data}
\name{mpip}
\alias{mpip}
\title{Multi-center Post-Infarction Project}
\source{
\href{https://svn.r-project.org/R-packages/trunk/survival/Examples/testreg/data.mpip}{
      Survival package - Revision 6780}
}
\description{
Multi-center Post-Infarction Project
}
\details{
A data frame with 866 observations (rows)
and 13 variables (columns),
taken from an environmental study that followed patients admitted to
hospital with a myocardial infarction. The goal of the study was to
identify factors which would be important in predicting the clinical
course of the patients.
\cr \cr
Columns are:
\describe{

 \item{ved}{Ventricular etopic depolarizations/hour,
 from a 24-hour Holter (ECG) monitor. A large number of these
irregular heartbeats may predict a high risk of fatal arrythmia.
The variable is highly skewed.}
 \item{angina}{Angina \describe{
   \item{0}{None}
   \item{1}{With physical activity or emotion}
   \item{2}{At rest}
   }}
\item{educat}{Education level. 1=postgraduate. 8=less than grade 7}
\item{mi}{Myocardial infarction \describe{
   \item{0}{No}
   \item{1}{Yes}
   }}
\item{nyha}{New York Heart Association Class \describe{
   \item{1}{Cardiac disease, but no symptoms and no
            limitation in ordinary physical activity}
   \item{2}{Mild symptoms (Mild shortness of breath and/or angina)
            and slight limitation during ordinary activity.}
   \item{3}{Marked limitation in activity due to symptoms,
            even during less-than-ordinary activity, e.g. walking
            short distances (20-100 m). Comfortable only at rest.}
   \item{4}{Severe limitations. Experiences symptoms even while at rest.
            Mostly bedbound patients.}
   }}
\item{rales}{Pulmonary rales on initial examination. \describe{
   \item{0}{No}
   \item{1}{Yes}
   }}
\item{ef}{Ejection fraction: percentage of blood cleared from the heart
  on each contraction.}
\item{ecg}{ECG classification. Anterior vs. inferior vs. other
   was the main grouping of interest. \describe{
   \item{11 or 12}{Anterior}
   \item{14}{Inferior}
   }}
\item{anyAngina}{Any angina. Binary classification based on
 variable angina above. \describe{
   \item{0}{No}
   \item{1}{Yes}
   }}
\item{futime}{Follow-up time (days)}
\item{status}{ \describe{
   \item{0}{Alive}
   \item{1}{Died}
   }}
\item{date}{Date of enrollment, with reference to day 0, 1/1/1960}
\item{bb}{Use of beta-blockers. \describe{
   \item{0}{No}
   \item{1}{Yes}
   }}
\item{lved}{Log ved. Derived from ved above, as
\eqn{lved = log(ved + 0.02)}. This is done to overcome skewing.}

}
}
\references{
The Multicenter Postinfarction Research Group 1983.
Risk stratification and survival after myocardial infarction.
\emph{N Engl J Med}. \bold{309}(6):331-6.
\href{http://dx.doi.org/10.1056/NEJM198308113090602}{NEJM (paywall)}
}
\seealso{
\code{\link{plotTerm}}
}

