% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_surv_shap.R
\name{plot.aggregated_surv_shap}
\alias{plot.aggregated_surv_shap}
\title{Plot Aggregated SurvSHAP(t) Explanations for Survival Models}
\usage{
\method{plot}{aggregated_surv_shap}(
  x,
  geom = "importance",
  ...,
  title = "default",
  subtitle = "default",
  max_vars = 7,
  colors = NULL
)
}
\arguments{
\item{x}{an object of class \code{aggregated_surv_shap} to be plotted}

\item{geom}{character, one of \code{"importance"}, \code{"beeswarm"}, \code{"profile"} or \code{"curves"}. Type of chart to be plotted; \code{"importance"} shows the importance of variables over time and aggregated, \code{"beeswarm"} shows the distribution of SurvSHAP(t) values for variables and observations, \code{"profile"} shows the dependence of SurvSHAP(t) values on variable values, \code{"curves"} shows all SurvSHAP(t) curves for selected variable colored by its value or with functional boxplot if \code{boxplot = TRUE}.}

\item{...}{additional parameters passed to internal functions}

\item{title}{character, title of the plot}

\item{subtitle}{character, subtitle of the plot, \code{'default'} automatically generates "created for the XXX model (n = YYY)", where XXX is the explainer label and YYY is the number of observations used for calculations}

\item{max_vars}{maximum number of variables to be plotted (least important variables are ignored), by default 7}

\item{colors}{character vector containing the colors to be used for plotting variables (containing either hex codes "#FF69B4", or names "blue")}
}
\value{
An object of the class \code{ggplot}.
}
\description{
This functions plots objects of class \code{aggregated_surv_shap} - aggregated time-dependent
explanations of survival models created using the \code{model_survshap()} function.
}
\section{Plot options}{

\subsection{\code{plot.aggregated_surv_shap(geom = "importance")}}{
\itemize{
\item \code{rug} - character, one of \code{"all"}, \code{"events"}, \code{"censors"}, \code{"none"} or \code{NULL}. Which times to mark on the x axis in \code{geom_rug()}.
\item \code{rug_colors} - character vector containing two colors (containing either hex codes "#FF69B4", or names "blue"). The first color (red by default) will be used to mark event times, whereas the second (grey by default) will be used to mark censor times.
\item \verb{xlab_left, ylab_right} - axis labels for left and right plots (due to different aggregation possibilities)
}
}

\subsection{\code{plot.aggregated_surv_shap(geom = "beeswarm")}}{
\itemize{
\item no additional parameters
}
}

\subsection{\code{plot.aggregated_surv_shap(geom = "profile")}}{
\itemize{
\item \code{variable} - variable for which the profile is to be plotted, by default first from result data
\item \code{color_variable} - variable used to denote the color, by default equal to \code{variable}
}

#' ## \code{plot.aggregated_surv_shap(geom = "curves")}
\itemize{
\item \code{variable} - variable for which SurvSHAP(t) curves are to be plotted, by default first from result data
\item \code{boxplot} - whether to plot functional boxplot with marked outliers or all curves colored by variable value
}
}
}

\examples{
\donttest{
veteran <- survival::veteran
rsf_ranger <- ranger::ranger(
    survival::Surv(time, status) ~ .,
    data = veteran,
    respect.unordered.factors = TRUE,
    num.trees = 100,
    mtry = 3,
    max.depth = 5
)
rsf_ranger_exp <- explain(
    rsf_ranger,
    data = veteran[, -c(3, 4)],
    y = survival::Surv(veteran$time, veteran$status),
    verbose = FALSE
)

ranger_global_survshap <- model_survshap(
    explainer = rsf_ranger_exp,
    new_observation = veteran[
        c(1:4, 17:20, 110:113, 126:129),
        !colnames(veteran) \%in\% c("time", "status")
    ],
    y_true = survival::Surv(
        veteran$time[c(1:4, 17:20, 110:113, 126:129)],
        veteran$status[c(1:4, 17:20, 110:113, 126:129)]
    ),
    aggregation_method = "integral",
    calculation_method = "kernelshap",
)
plot(ranger_global_survshap)
plot(ranger_global_survshap, geom = "beeswarm")
plot(ranger_global_survshap, geom = "profile",
     variable = "age", color_variable = "karno")
plot(ranger_global_survshap, geom = "curves",
     variable = "age")
plot(ranger_global_survshap, geom = "curves",
     variable = "age", boxplot = TRUE)
}

}
