% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_set_theme_survex.R
\name{set_theme_survex}
\alias{set_theme_survex}
\alias{theme_default_survex}
\alias{theme_vertical_default_survex}
\title{Default Theme for survex plots}
\usage{
set_theme_survex(
  default_theme = "drwhy",
  default_theme_vertical = default_theme
)

theme_default_survex()

theme_vertical_default_survex()
}
\arguments{
\item{default_theme}{object - string ("drwhy" or "ema") or an object of ggplot theme class. Will be applied by default by \code{survex} to all horizontal plots}

\item{default_theme_vertical}{object - string ("drwhy" or "ema") or an object of ggplot theme class. Will be applied by default by \code{survex} to all vertical plots}
}
\value{
list with current default themes
}
\description{
Default Theme for survex plots
}
\examples{
old <- set_theme_survex("ema")
\donttest{
library(survival)
library(survex)

model <- randomForestSRC::rfsrc(Surv(time, status) ~ ., data = veteran)
exp <- explain(model)

p_parts_lime <- predict_parts(exp, veteran[1, -c(3, 4)], type = "survlime")
old <- set_theme_survex("drwhy")
plot(p_parts_lime)
old <- set_theme_survex(ggplot2::theme_void(), ggplot2::theme_void())
plot(p_parts_lime)
}

}
