% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relative_site_richness_scores.R
\name{relative_site_richness_scores}
\alias{relative_site_richness_scores}
\title{Relative site richness scores}
\usage{
relative_site_richness_scores(site_data, site_probability_columns)
}
\arguments{
\item{site_data}{\code{\link[sf:sf]{sf::sf()}} object with site data.}

\item{site_probability_columns}{\code{character} names of \code{numeric}
columns in the argument to \code{site_data} that contain modeled
probabilities of occupancy for each feature in each site.
Each column should correspond to a different feature, and contain
probability data (values between zero and one). No missing (\code{NA})
values are permitted in these columns.}
}
\value{
A \code{numeric} vector of richness scores. Note that
these values are automatically rescaled between 0.01 and 1.
}
\description{
Calculate relative site richness scores. Sites with greater scores
are predicted to be more likely to contain more species. Note that these
scores are relative to each other and scores calculated using different
matrices cannot be compared to each other.
}
\details{
The relative site richness scores are calculated using the following
procedure:

\enumerate{
\item Let \eqn{J} denote the set of sites (indexed by \eqn{j}),
\eqn{I} denote the set of features (indexed by \eqn{i}), and
\eqn{x_{ij}} denote the modeled probability of feature \eqn{i \in I}
occurring in sites \eqn{j \in J}.

\item Next, we will sum the values for each site:
\eqn{y_j = \sum_{i \in I} x_{ij}}.

\item Finally, we will linearly rescale the \eqn{y_j} values between 0.01
and 1 to produce the scores.

}
}
\examples{
# set seed for reproducibility
set.seed(123)

# simulate data for 3 features and 4 planning units
x <- tibble::tibble(x = rnorm(4), y = rnorm(4),
                     p1 = c(0.095, 0.032, 0.5, 0.924),
                     p2 = c(0.023, 0.014, 0.4, 0.919),
                     p3 = c(0.075, 0.046, 0.9, 0.977))
x <- sf::st_as_sf(x, coords = c("x", "y"))

# print data,
# we can see that the fourth site has the highest modeled probabilities of
# occupancy across all species
print(x)

# plot sites' occupancy probabilities
plot(x[, c("p1", "p2", "p3")], pch = 16, cex = 3)

# calculate scores
s <- relative_site_richness_scores(x, c("p1", "p2", "p3"))

# print scores,
# we can see that site 4 has the highest richness score
print(s)

# plot sites' richness scores
x$s <- s
plot(x[, c("s")], pch = 16, cex = 3)

}
