% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{rewards}
\alias{rewards}
\title{Reward challenges (deprecated)}
\format{
This nested tidy data frame contains the following columns:
\describe{
  \item{\code{season_name}}{Season name}
  \item{\code{season}}{Sesaon number}
  \item{\code{episode}}{Episode number of when the reward challenge was played}
  \item{\code{title}}{Episode title}
  \item{\code{day}}{Day of the immunity challenge rather than the reward (to be updated)}
  \item{\code{Reward}}{Winners of the reward challenge. Tidy data frame. See details for more}
}
}
\source{
\url{https://en.wikipedia.org/wiki/Survivor_(American_TV_series)}
}
\usage{
rewards
}
\description{
A dataset containing details on the reward challenges for each season,
This holds the same information as the challenges dataset. (superceded by the `challenges` dataset)
}
\details{
This is a nested data frame since more than one person can win the reward.
The list of castaways include all those that participated in the reward rather than simply
the castaway that won the challenge. Many challenges in the merge are such that there is
one winner of the challenge and they can choose a set number of people to join them. Typically
the first person on the list is the person who won the challenge and other just participated
in the reward. In the case where castaways were split into teams for the challenge (post merge),
technically they all won.
}
\examples{
library(dplyr)
library(tidyr)
rewards
rewards \%>\%
  unnest(reward)
}
\keyword{datasets}
