% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{challenges}
\alias{challenges}
\title{Challenges}
\format{
This nested data frame contains the following columns:
\describe{
  \item{\code{season_name}}{The season name}
  \item{\code{season}}{The season number}
  \item{\code{episode}}{Episode number}
  \item{\code{day}}{The day of the tribal council}
  \item{\code{challenge_type}}{The challenge type e.g. immunity, reward, etc}
  \item{\code{challenge_name}}{[under development] Name of the challenge played (TBA)}
  \item{\code{outcome_type}}{Whether the challenge is individual or tribal. Some individual reward challenges may involve multiple castawats as the winner gets to choose who they bring along}
  \item{\code{winners_id}}{The ID of the winners of the challenge. Consistent with \code{castaway_id}}
  \item{\code{winners}}{The list of winners. Either the list of people in the tribe which won, list of people that participated on the reward or the individual winner}
  \item{\code{winning_tribe}}{Name of the winner tribe. \code{NA} during the merge}
}
}
\source{
\url{https://en.wikipedia.org/wiki/Survivor_(American_TV_series)}
}
\usage{
challenges
}
\description{
The challenges data set has been superseded by two new data sets \code{challenge_results} and
\code{challenge_description}.
}
\details{
A nested tidy data frame of immunity and reward challenge results. The
winners and winning tribe of the challenge are found by expanding the `winners`
column. For individual immunity challenges the winning tribe is simply `NA`.

Typically in the merge if a single person win a reward they are allowed to bring
others along with them. The first castaway in the expanded list is likely to be the
winner and the subsequent players those they brought along with them. Although,
not always. Occasionally in the merge the castaways are split into two teams for
the purpose of the reward, in which case all castaways win the reward rather than
a single person.

The `day` field on this data set represents the day of the tribal council rather
than the day of the challenge. This is to more easily associate the reward challenge
with the immunity challenge and result of the tribal council. It also helps for
joining tables.

Note the challenges table is the combined immunity and rewards tables which will
eventually be dropped in later releases.
}
\examples{
library(dplyr)
library(tidyr)
challenges \%>\%
  filter(season == 40) \%>\%
  unnest(winners)
}
\keyword{datasets}
