# survxai
[![CRAN_Status_Badge](http://www.r-pkg.org/badges/version/survxai)](https://CRAN.R-project.org/package=survxai)
[![Total Downloads](https://cranlogs.r-pkg.org/badges/grand-total/survxai)](https://cranlogs.r-pkg.org/badges/grand-total/survxai)
[![Build Status](https://travis-ci.org/MI2DataLab/survxai.svg?branch=master)](https://travis-ci.org/MI2DataLab/survxai)
[![Coverage Status](https://img.shields.io/codecov/c/github/MI2DataLab/survxai/master.svg)](https://codecov.io/github/MI2DataLab/survxai?branch=master)
[![status](https://joss.theoj.org/papers/10.21105/joss.00961)](https://joss.theoj.org/papers/10.21105/joss.00961)
[![CII Best Practices](https://bestpractices.coreinfrastructure.org/projects/2123/badge)](https://bestpractices.coreinfrastructure.org/projects/2123)
[![DOI](https://zenodo.org/badge/137778994.svg)](https://zenodo.org/badge/latestdoi/137778994)

Survival analysis models are used primarily in medicine and churn analysis. Due to many applications, we are witnessing a fast development of a wide range of black-box survival models. Their lack of interpretability makes them unusable for analyzes that require an understanding of the model behavior. 

An R package survxai is a tool for creating explanations of survival models. For both, complex and simple survival models. It also enables to compare them. Currently, four explanation methods are implemented. We can divide them into 2 groups: local and global.

The read more about the `surxvai` package see paper [survxai: an R package for structure-agnostic explanations of survival models](https://joss.theoj.org/papers/10.21105/joss.00961)in The Journal of Open Source Software.

## Install
```
devtools::install_github("MI2DataLab/survxai")
```

## CheatSheet

<a href="https://github.com/MI2DataLab/survxai/blob/master/materials/survxai-cheatsheet.pdf">
<img src="https://github.com/MI2DataLab/survxai/blob/master/materials/survxai-cheatsheet.png?raw=true">
</a>

## News
Informations about changes in `survxai` relases can be found in [NEWS](https://github.com/MI2DataLab/survxai/blob/master/NEWS.md).

## How to contribute
Informations about creating issues and pull requests in `survxai` can be found in [CONTRIBUTING](https://github.com/MI2DataLab/survxai/blob/master/CONTRIBUTING.md).


## Acknowledgments
Work on this package is financially supported by the 'NCN Opus grant 2016/21/B/ST6/02176'.
