% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dlg_open.R
\docType{data}
\name{dlg_open}
\alias{dlg_open}
\alias{dlgOpen}
\alias{dlg_filters}
\alias{dlgFilters}
\alias{dlgOpen.gui}
\alias{dlgOpen.textCLI}
\alias{dlgOpen.nativeGUI}
\title{Modal dialog to select a file.}
\format{An object of class \code{matrix} with 11 rows and 2 columns.}
\usage{
dlg_open(default, title, multiple = FALSE, filters = dlg_filters["All", ],
  ..., gui = .GUI)

dlgOpen(default, title, multiple = FALSE, filters = dlg_filters["All", ],
  ..., gui = .GUI)

dlg_filters

dlgFilters

\method{dlgOpen}{gui}(default, title, multiple = FALSE,
  filters = dlg_filters["All", ], ..., gui = .GUI)

\method{dlgOpen}{textCLI}(default, title, multiple = FALSE,
  filters = dlg_filters["All", ], ..., gui = .GUI)

\method{dlgOpen}{nativeGUI}(default, title, multiple = FALSE,
  filters = dlg_filters["All", ], ..., gui = .GUI)
}
\arguments{
\item{default}{The default file to start with (use \code{/dir/*} or \code{/dir/*.*} to
start in a given directory).}

\item{title}{A title to display on top of the dialog box.}

\item{multiple}{Is a multiple selection of files allowed?}

\item{filters}{A specification of file filters as a \code{nx2} matrix, or a
character string with even number of items. First items is the label, second
one is the filter. See \code{dlg_filters} for examples. This is currently ignored
on MacOS, since such kind of filter is defined differently there.}

\item{...}{Pass further arguments to methods.}

\item{gui}{The 'gui' object concerned by this dialog box.}
}
\value{
The modified 'gui' object is returned invisibly. The chosen file(s),
or an empty string if the "cancel" button was clicked is found in \code{gui$res}
(see example).
}
\description{
Select an existing file, or create a new one.
}
\note{
On RStudio, \code{multiple = TRUE} cannot be honored. So, for now, you can
only select one file there. Also, the textual version is painful to indicate
the full path of several files. So, it should use globbing, and/or indication
of a path followed by a selection in a list (to be done in further versions).
Finally, the 'RStudio' version of this dialog box currently ignores the
\code{filters =} argument.
}
\examples{
\dontrun{
# Choose one R file
dlg_open(title = "Select one R file", filters = dlg_filters[c("R", "All"), ])$res
# Choose several files
dlg_open(multiple = TRUE)$res
}
}
\seealso{
\code{\link[=dlg_save]{dlg_save()}}, \code{\link[=dlg_dir]{dlg_dir()}}
}
\concept{
Modal dialog box
}
\keyword{datasets}
\keyword{misc}
