% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svdvis.R
\name{svd.heatmap}
\alias{svd.heatmap}
\title{Visualizing Singular Vectors or Principal Components by Heatmaps}
\usage{
svd.heatmap(svd.obj, r = NULL, group = NULL, weights = NULL,
  alpha = 0.7, low = "#FFFFFF", high = "#9E0142")
}
\arguments{
\item{svd.obj}{A list, resulted from applying svd to a dataset, with \code{u}, \code{d}, and \code{v} corresponding to left singular vector, singular values, and right singular vectors, respectively. Alternatively, supply singular vectors, \code{v}.}

\item{r}{A positive integer to use only the first \code{r} vectors in visualization. If not specified, all vectors available in \code{svd.obj$v} are visualized.}

\item{group}{A vector of length \code{n}, specifying groups (e.g., phenotypes or conditions for \code{n} samples).}

\item{weights}{A vector of length \code{r}. If "sv", singular values contained in \code{svd.obj$d[1:r]} are used.}

\item{alpha}{A numeric value for transparency.}

\item{low}{A hex color code to color the lowest value.}

\item{high}{A hex color code to color the highest value.}
}
\value{
\code{svd.heatmap} creates and draws a figure, which is a \code{ggplot} object.
}
\description{
Creates a heatmap from selected singular vectors or principal components.
Principal components can be plotted by setting \code{weights = "sv"}.
Colors for heatmap can be specified by optional arguments \code{low} and \code{high} colors.
}
\examples{
set.seed(1234)
dat = matrix(rnorm(1000), 100, 10)
svd.obj = svd(dat)
colnames(svd.obj$v) = paste0("V",1:10)
rownames(svd.obj$v) = paste0("Sample",1:10)
svd.heatmap(svd.obj, r=5)
}
\author{
Neo Christopher Chung \email{nchchung@gmail.com}
}

