% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svgtools.R
\name{referenceBar}
\alias{referenceBar}
\title{Adjust (stacked) bar chart that is aligned around a reference category}
\usage{
referenceBar(
  svg,
  frame_name,
  group_name,
  scale_real,
  values,
  reference,
  nullvalue = 0,
  alignment = "horizontal",
  has_labels = TRUE,
  label_position = "center",
  decimals = 0,
  display_limits = 0
)
}
\arguments{
\item{svg}{XML document with SVG content}

\item{frame_name}{Name (attribute 'id') of frame (XML element 'rect') for positioning bar segments (and value labels).}

\item{group_name}{Name (attribute 'id') of group (XML element 'g') containing either bar segments (and value labels) or further groups, containing bar segments (and value labels) themselves.}

\item{scale_real}{Numeric vector (e.g. \code{c(0,100)}) of arbitrary length. Only minimum and maximum are used for scaling of values.}

\item{values}{Either a numeric vector, a numeric matrix or a dataframe with only numeric columns.\cr
If a vector is given, it corresponds to one bar (group of bar segments and, optionally, value labels).\cr
If a matrix or dataframe is given, rows define the value set for several (stacked) bars grouped together.}

\item{reference}{Reference category (=column number of values). Bar segments up to this category lie to the left (horizontal) or to the bottom (vertical), bar segments above this category lie to the right (horizontal) or the top (vertical) of the bar chart.}

\item{nullvalue}{Value that defines the "center" of the bar segments (for left/right or bottom/top positioning)}

\item{alignment}{Character value. Accepts 'horizontal' (default) or 'vertical'. See details.}

\item{has_labels}{Are there value labels (of XML type 'text') to adjust? (default TRUE)}

\item{label_position}{Character value. Accepts 'start', 'center' (default) and 'end'. This refers to the underlying bar segments.}

\item{decimals}{Integer value defining the number of decimal digits of value labels (default 0).}

\item{display_limits}{Interval for (small) values, that lead to suppression of the corresponding value labels. If only one value x is given, it is turned into the interval c(-x,x). (default 0 = no suppression)}
}
\value{
XML document with SVG content
}
\description{
Adjusts the horizontal (XML attribute 'x') or vertical (XML attribute 'y') position as well as width/height of bar segments (XML elements of type 'rect') and optionally value labels (XML elements of type 'text'). Positions are calculated relative to a given frame (XML element of type 'rect'), a nullvalue and the position of a data value within the minimum and maximum of a given scale. The first n bar segments and, optionally, value labels of each bar (n is called the \code{reference} category) are position to the left (in horizontal alignment) or bottom (in vertical alignment) of the nullvalue, while the others are positioned to the right or top.\cr
For further description see \code{\link{stackedBar}}.
}
\details{
See \code{\link{stackedBar}}.
}
\examples{
#read SVG file
fpath <- system.file("extdata", "fig5.svg", package="svgtools")
svg <- read_svg(file = fpath)

#adjust bars
values <- matrix(c(1,2,3,4,2,3,4,1,3,4,1,2,4,1,2,3,1,2,3,4)*10, 
                 nrow = 5, byrow = TRUE)
svg <- referenceBar(svg = svg, frame_name = "frame", group_name = "group",
                    scale_real = c(-100,100), values = values, 
                    reference = 2, nullvalue = 0)
}
