% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svs.r
\name{fast_psa}
\alias{fast_psa}
\alias{fast_psi}
\alias{fast_plsa}
\alias{fast_plsi}
\title{Probabilistic Latent Semantic Analysis}
\usage{
fast_psa(dat, k, symmetric = FALSE, transform = 1, tol = 1e-08)

fast_psi(dat, k, symmetric = FALSE, transform = 1, tol = 1e-08)

fast_plsa(dat, k, symmetric = FALSE, transform = 1, tol = 1e-08)

fast_plsi(dat, k, symmetric = FALSE, transform = 1, tol = 1e-08)
}
\arguments{
\item{dat}{Input data: can be a table or a data frame (but the data frame must have only two columns).}

\item{k}{Numeric specification of the number of latent classes to compute.}

\item{symmetric}{Logical indicating whether to compute the symmetric or the asymmetric solution.}

\item{transform}{Numeric specification of the "tempering" transformation as explained in Hofmann (1999: 51-52).}

\item{tol}{Numeric specification of the convergence criterion.}
}
\value{
A list with components:
\item{\code{prob0} }{The probabilities of the latent classes.}
\item{\code{prob1} }{The probabilities for the first set of levels (\emph{viz.} the row levels of a frequency table). The rows of \code{prob1} sum to 1 if \code{symmetric = FALSE}, the columns sum to 1 if \code{symmetric = TRUE}.}
\item{\code{prob2} }{The probabilities for the second set of levels (\emph{viz.} the column levels of a frequency table). The columns of \code{prob2} sum to 1.}
}
\description{
A fast procedure for computing probabilistic latent semantic analysis.
}
\details{
From version 1.1.0 of the \pkg{svs} package on, probabilistic latent semantic analysis is a special case of latent class analysis.
}
\examples{
SndT_Fra <- read.table(system.file("extdata", "SndT_Fra.txt", package = "svs"),
   header = TRUE, sep = "\t", quote = "\"", encoding = "UTF-8",
   stringsAsFactors = FALSE)
psa.SndT_Fra <- fast_psa(SndT_Fra, k = 7)
psa.SndT_Fra
}
\references{
Hofmann, Th. (1999). Probabilistic latent semantic indexing.
  \emph{SIGIR'99: Proceedings of the 22nd annual international SIGIR conference on research and development in information retrieval}, 50--57.
}
