% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svs.r
\name{pc_plot}
\alias{pc_plot}
\title{Plotting Parallel Coordinates}
\usage{
pc_plot(
  x,
  col = "darkgrey",
  cex = 1,
  font = 1,
  family = "",
  pch = 20,
  pcol = col,
  pcex = cex,
  lcol = col,
  lwd = 1,
  lty = 1,
  acol = "black",
  alwd = 1,
  alty = 1,
  las = 1,
  add_scale = FALSE,
  main = NULL,
  sub = NULL
)
}
\arguments{
\item{x}{A numeric matrix.}

\item{col}{The color of the text labels, points and connecting lines: see \code{\link[grDevices]{colors}}.}

\item{cex}{The character expansion factor: A numeric value to specify the size of the text labels and the points.}

\item{font}{The font of the text labels: \code{1} for plain, \code{2} for bold, \code{3} for italic, and \code{4} for bold italic.}

\item{family}{The font family of the text labels: \code{"serif"}, \code{"sans"}, \code{"mono"}, or one of the \code{\link[grDevices]{Hershey}} fonts.}

\item{pch}{The plotting character for displaying points: see \code{\link[graphics]{points}}.}

\item{pcol}{The color of the plotting character: see \code{\link[grDevices]{colors}}.}

\item{pcex}{The character expansion factor of the plotting character: a numeric value to specify the size of the plotting character.}

\item{lcol}{The color of the connecting lines: see \code{\link[grDevices]{colors}}.}

\item{lwd}{The line width of the connecting lines: a numeric value to specify the width of the connecting lines.}

\item{lty}{The line type of the connecting lines: \code{0} or \code{"blank"}, \code{1} or \code{"solid"}, \code{2} or \code{"dashed"}, \code{3} or
\code{"dotted"}, \code{4} or \code{"dotdash"}, \code{5} or \code{"longdash"}, \code{6} or \code{"twodash"}.}

\item{acol}{The color of the parallel axes: see \code{\link[grDevices]{colors}}.}

\item{alwd}{The line width of the parallel axes: a numeric value to specify the width of the parallel axes.}

\item{alty}{The line type of the parallel axes: \code{0} or \code{"blank"}, \code{1} or \code{"solid"}, \code{2} or \code{"dashed"}, \code{3} or
\code{"dotted"}, \code{4} or \code{"dotdash"}, \code{5} or \code{"longdash"}, \code{6} or \code{"twodash"}.}

\item{las}{The reading direction of the labels on the axes ("label axis style"): either a numeric value between \code{0} and \code{3} (see \code{las} in
\code{\link[graphics]{par}}), or a character value matching either \code{"horizontal"} or \code{"vertical"}.}

\item{add_scale}{Logical specifying whether to add a scale for the parallel axes (which are normalized).}

\item{main}{A character string for the main title of the plot.}

\item{sub}{A character string for the subtitle of the plot.}
}
\value{
A parallel coordinate plot.
}
\description{
A function for plotting parallel coordinates.
}
\examples{
SndT_Fra <- read.table(system.file("extdata", "SndT_Fra.txt", package = "svs"),
   header = TRUE, sep = "\t", quote = "\"", encoding = "UTF-8",
   stringsAsFactors = FALSE)
sca.SndT_Fra <- fast_sca(SndT_Fra)
pc_plot(sca.SndT_Fra$pos1, las = "vertical")
}
