% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oin.R
\name{oin_ctrl}
\alias{oin_ctrl}
\title{Check the control numbers for \code{oin}}
\usage{
oin_ctrl(oin, force_logical = FALSE)
}
\arguments{
\item{oin}{A vector of class \code{oin}. See \link{as.oin}.}

\item{force_logical}{If TRUE, force all NA in oin to be FALSE. Default is FALSE.}
}
\value{
Logical vector indicating if a oin is correct (\code{TRUE}) or not (\code{FALSE})
}
\description{
Calculates the control number using the Luhn algorithm and compare it with the control number in the organization identity number (oin).
}
\examples{
ex_oin <- c("556000-4615", "232100-0156", "802002-4280", "232100-0157", "802002-4281")
oin_ctrl(ex_oin)

}
\references{
\href{http://www.skatteverket.se/download/18.70ac421612e2a997f85800040284/1302507382017/70909.pdf}{SKV 709}
}

