% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distance.R
\name{distance}
\alias{distance}
\title{Distance Between Coordinates}
\usage{
distance(
  lat1,
  lon1,
  lat2,
  lon2,
  radius = convert.distance(6371, "km", "nm"),
  units = c("nm", "km", "mi"),
  ellipsoid = datum(),
  iter.limit = 20,
  method = c("lawofcosines", "haversine", "vincenty")
)
}
\arguments{
\item{lat1, lon1, lat2, lon2}{The latitude and longitude of the first and 
second points in decimal degrees.}

\item{radius}{radius of sphere.}

\item{units}{units of distance. Can be "km" (kilometers), 
"nm" (nautical miles), or "mi" (statute miles), or any partial match 
thereof (case sensitive).}

\item{ellipsoid}{ellipsoid model parameters as returned from a 
call to \code{\link{datum}}.}

\item{iter.limit}{An integer value defining the limit of iterations 
for Vincenty method.}

\item{method}{Character defining the distance method to use. Can be 
"lawofcosines", "haversine", "vincenty", or any partial match 
thereof (case sensitive).}
}
\description{
Calculates the distance between two coordinates using the Law 
  of Cosines, Haversine, or Vincenty methods.
}
\examples{
# What is the distance from San Diego, CA to Honolulu, HI?
distance(32.87, -117.25, 21.35, -157.98, method = "lawofcosines")
distance(32.87, -117.25, 21.35, -157.98, method = "haversine")
distance(32.87, -117.25, 21.35, -157.98, method = "vincenty")

}
\references{
Code adapted from JavaScript by Chris Veness 
\url{http://www.movable-type.co.uk/scripts/latlong.html} \cr
Vincenty, T. 1975.  Direct and inverse solutions of geodesics on the 
ellipsoid with application of nested equations. Survey Review 22(176):88-93 \cr
\url{http://www.ngs.noaa.gov/PUBS_LIB/inverse.pdf}.
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
