% Generated by roxygen2 (4.0.1.99): do not edit by hand
\name{install_course_github}
\alias{install_course_github}
\title{Install a course from a GitHub repository}
\usage{
install_course_github(github_username, course_name, branch = "master",
  multi = FALSE)
}
\arguments{
\item{github_username}{The username that owns the course repository.}

\item{course_name}{The name of the repository which should be the name of the course.}

\item{branch}{The branch of the repository containing the course. The default branch is \code{"master"}.}

\item{multi}{The user should set to \code{TRUE} if the repository contains multiple courses. The default value is \code{FALSE}.}
}
\description{
Install a course from a GitHub repository
}
\examples{
\dontrun{

install_course_github("bcaffo", "Linear_Regression")
install_course_github("jtleek", "Twitter_Map", "geojson")
}
}
\seealso{
Other InstallCourses: \code{\link{InstallCourses}};
  \code{\link{install_course_directory}};
  \code{\link{install_course_dropbox}};
  \code{\link{install_course_google_drive}};
  \code{\link{install_course_url}};
  \code{\link{install_course_zip}};
  \code{\link{install_from_swirl}};
  \code{\link{uninstall_course}}; \code{\link{zip_course}}
}

