% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/biocManifest.R
\name{BiocSVNManifest}
\alias{BiocSVNManifest}
\title{Create a manifest of Bioc SVN locations}
\usage{
BiocSVNManifest(bioc_vers = "devel", not_in_repo = character(),
  software_only = TRUE)
}
\arguments{
\item{bioc_vers}{A version number for a bioc release, or \code{"devel"} to
for the current devel trunk}

\item{not_in_repo}{character. A vector of package names which are
in SVN but do not appear in the bioconductor repository}

\item{software_only}{logical. Should only software packages be
included in the manifest? Defaults to TRUE}
}
\value{
A PkgManifest which contains SVN locations for all
packages found in the specified bioc repositories, as well
as those listed in \code{not_in_repo}
}
\description{
Create a manifest of Bioc SVN locations
}
\details{
In combination with the \code{lazyRepo} function, this
manifest can be used to work from a local, working checkout of a
set of inter-dependent Bioconductor packages.
}
\examples{
bman = BiocSVNManifest()
bman
\dontrun{
repo = lazyRepo("rtracklayer", bman)
}
}
\seealso{
\code{\link{lazyRepo}}
}

