% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_out.R
\name{read_out}
\alias{read_out}
\title{Read time series data from SWMM's .out file}
\usage{
read_out(file = "", iType = NULL, object_name = NULL, vIndex = NULL)
}
\arguments{
\item{file}{The file to be read.}

\item{iType}{Sets the result type: 0 for Subcatchments,
1 for nodes, 2 for links, 3 for system variables.
Leave empty for retrieving elements available.}

\item{object_name}{Sets the objects of which time series data is returned.
Leave empty for retrieving elements available.}

\item{vIndex}{Sets the variables to be read (s. Details).
Leave empty for retrieving elements available.}
}
\value{
A list of xts-objects.
}
\description{
Reads the binary output ('.out') generated by the stormwater
management model 'SWMM' and creates a list of xts-objects.
}
\details{
vIndex depends on the result type. Choices are...

for each \strong{subcatchment} variable:
\itemize{
\item 0 for rainfall rate (in/hr or mm/hr),
\item 1 for snow depth (inches or millimeters),
\item 2 for evaporation loss (in/day or mm/day),
\item 3 for infiltration loss (in/hr or mm/hr),
\item 4 for runoff flow (flow units),
\item 5 for groundwater flow into the drainage network (flow units),
\item 6 for groundwater elevation (ft or m),
\item 7 for soil moisture in the unsaturated groundwater zone (volume fraction),
\item 7 + N for washoff concentration of each pollutant (mass/liter).
}

for each \strong{node} variable:
\itemize{
\item 0 for water depth (ft or m above the node invert elevation),
\item 1 for hydraulic head (ft or m, absolute elevation per vertical datum),
\item 2 for stored water volume (including ponded water, ft3 or m3),
\item 3 for lateral inflow (runoff + all other external inflows, in flow units),
\item 4 for total inflow (lateral inflow + upstream inflows, in flow units),
\item 5 for surface flooding (excess overflow when the node is at full depth, in flow units),
\item 5 + N for concentration of each pollutant after any treatment (mass/liter),
}

for each \strong{link} variable:
\itemize{
\item 0 for flow rate (flow units),
\item 1 for average water depth (ft or m),
\item 2 for flow velocity (ft/s or m/s),
\item 3 for volume of water (ft3 or m3),
\item 4 for capacity (fraction of full area filled by flow for conduits; control setting for pumps and regulators),
\item 4 + N for concentration of each pollutant (mass/liter),
}

for each \strong{system-wide} variable:
\itemize{
\item 0 for air temperature (deg. F or deg. C),
\item 1 for total rainfall (in/hr or mm/hr),
\item 2 for total snow depth (inches or millimeters),
\item 3 for average losses (in/hr or mm/hr),
\item 4 for total runoff (flow units),
\item 5 for total dry weather inflow (flow units),
\item 6 for total groundwater inflow (flow units),
\item 7 for total RDII inflow (flow units),
\item 8 for total external inflow (flow units),
\item 9 for total direct inflow (flow units),
\item 10 for total external flooding (flow units),
\item 11 for total outflow from outfalls (flow units),
\item 12 for total nodal storage volume ( ft3 or m3),
\item 13 for potential evaporation (in/day or mm/day),
\item 14 for actual evaporation (in/day or mm/day).
}
}
\examples{
 
\dontrun{
xts_list_of_results <- read_out("model.out")
} 

}
\seealso{
\code{\link[xts]{xts}}.
}
