/*
 * Decompiled with CFR 0.152.
 */
package main;

import beagleutil.Samples;
import main.GenotypeValues;
import vcf.Marker;
import vcf.Markers;

public final class FixedGenotypeValues
implements GenotypeValues {
    private final GenotypeValues gv;
    private final boolean[] isFixed;

    public FixedGenotypeValues(GenotypeValues genotypeValues, Markers markers) {
        this.gv = genotypeValues;
        this.isFixed = new boolean[genotypeValues.nMarkers()];
        for (int i = 0; i < this.isFixed.length; ++i) {
            if (!markers.contains(genotypeValues.marker(i))) continue;
            this.isFixed[i] = true;
        }
    }

    @Override
    public float value(int n, int n2, int n3) {
        return this.gv.value(n, n2, n3);
    }

    @Override
    public void add(int n, double[] dArray) {
        int n2 = 0;
        int n3 = this.gv.nMarkers();
        for (int i = 0; i < n3; ++i) {
            int n4 = this.gv.marker(i).nGenotypes();
            for (int j = 0; j < n4; ++j) {
                this.add(i, n, j, dArray[n2++]);
            }
        }
        assert (n2 == dArray.length);
    }

    @Override
    public void add(int n, int n2, int n3, double d) {
        if (!this.isFixed[n]) {
            this.gv.add(n, n2, n3, d);
        }
    }

    @Override
    public Samples samples() {
        return this.gv.samples();
    }

    @Override
    public int nSamples() {
        return this.gv.samples().nSamples();
    }

    @Override
    public Marker marker(int n) {
        return this.gv.marker(n);
    }

    @Override
    public Markers markers() {
        return this.gv.markers();
    }

    @Override
    public int nMarkers() {
        return this.gv.nMarkers();
    }
}

