/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import beagleutil.Samples;
import blbutil.Const;
import vcf.GL;
import vcf.Marker;
import vcf.Markers;
import vcf.VcfEmission;

public final class RefGL
implements GL {
    private final Samples samples;
    private final Markers markers;
    private final VcfEmission[] vma;

    public RefGL(Samples samples, VcfEmission[] vcfEmissionArray) {
        RefGL.checkData(samples, vcfEmissionArray);
        this.markers = RefGL.markers(vcfEmissionArray);
        this.samples = samples;
        this.vma = (VcfEmission[])vcfEmissionArray.clone();
    }

    private static void checkData(Samples samples, VcfEmission[] vcfEmissionArray) {
        for (int i = 0; i < vcfEmissionArray.length; ++i) {
            if (!vcfEmissionArray[i].samples().equals(samples)) {
                String string = "samples=" + samples + Const.nl + "pma[" + i + "].samples()=" + vcfEmissionArray[i].samples();
                throw new IllegalArgumentException(string);
            }
            if (vcfEmissionArray[i].isRefData()) continue;
            String string = "non-reference data at marker index " + i;
            throw new IllegalArgumentException(string);
        }
    }

    private static Markers markers(VcfEmission[] vcfEmissionArray) {
        Marker[] markerArray = new Marker[vcfEmissionArray.length];
        for (int i = 0; i < markerArray.length; ++i) {
            markerArray[i] = vcfEmissionArray[i].marker();
        }
        return new Markers(markerArray);
    }

    @Override
    public boolean isRefData() {
        return true;
    }

    @Override
    public float gl(int n, int n2, byte by, byte by2) {
        byte by3 = this.vma[n].allele1(n2);
        byte by4 = this.vma[n].allele2(n2);
        return by == by3 && by2 == by4 ? 1.0f : 0.0f;
    }

    @Override
    public byte allele1(int n, int n2) {
        return this.vma[n].allele1(n2);
    }

    @Override
    public byte allele2(int n, int n2) {
        return this.vma[n].allele2(n2);
    }

    @Override
    public int nMarkers() {
        return this.vma.length;
    }

    @Override
    public Marker marker(int n) {
        return this.markers.marker(n);
    }

    @Override
    public Markers markers() {
        return this.markers;
    }

    @Override
    public int nSamples() {
        return this.samples.nSamples();
    }

    @Override
    public Samples samples() {
        return this.samples;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[RefGL: nMarkers=");
        stringBuilder.append(this.nMarkers());
        stringBuilder.append(" nSamples=");
        stringBuilder.append(this.nSamples());
        for (VcfEmission vcfEmission : this.vma) {
            stringBuilder.append(Const.nl);
            stringBuilder.append(vcfEmission);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

