% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_gen_NL.R
\name{data.gen.nl2}
\alias{data.gen.nl2}
\title{Nonlinear system with Exogenous covariates}
\usage{
data.gen.nl2(nobs, ndim = 7, noise = 1)
}
\arguments{
\item{nobs}{The data length to be generated.}

\item{ndim}{The number of potential predictors (default is 9).}

\item{noise}{The noise level in the time series.}
}
\value{
A list of 3 elements: a vector of response (x), a matrix of potential predictors (dp) with each column containing one potential predictor, and a vector of true predictor numbers.
}
\description{
Nonlinear system with Exogenous covariates
}
\examples{
###synthetic example - Friedman
#Friedman with independent uniform variates
data.nl1 <- data.gen.nl1(nobs=1000)

#Friedman with correlated uniform variates
data.nl2 <- data.gen.nl2(nobs=1000)

plot.ts(cbind(data.nl1$x,data.nl2$x), col=c("red","blue"), main=NA, xlab=NA,
        ylab=c("Nonlinear system with \n independent uniform variates",
        "Nonlinear system with \n correlated uniform variates"))
}
\references{
Sharma, A., & Mehrotra, R. (2014). An information theoretic alternative to model a natural system using observational information alone. Water Resources Research, 50(1), 650-660.
}
