% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/trakt.user.watchlist.R
\name{trakt.user.watchlist}
\alias{trakt.user.watchlist}
\title{Get a user's watchlist}
\usage{
trakt.user.watchlist(user = getOption("trakt.username"), type = "shows",
  extended = "min")
}
\arguments{
\item{user}{Target user. Defaults to \code{getOption("trakt.username")}}

\item{type}{Either \code{shows} (default) or \code{movies}}

\item{extended}{Whether extended info should be provided.
Defaults to \code{"min"}, can either be \code{"min"} or \code{"full"}}
}
\value{
A \code{data.frame} containing stats.
}
\description{
\code{trakt.user.watchlist} pulls a user's watchlist.
Either all shows or movies currently watchlisted will be returned.
}
\note{
See \href{http://docs.trakt.apiary.io/#reference/users/ratings/get-watchlist}{the trakt API docs for further info}
}
\examples{
\dontrun{
get_trakt_credentials() # Set required API data/headers
mystats   <- trakt.user.watchlist() # Defaults to your username if set
seanstats <- trakt.user.watchlist(user = "sean")
}
}
\seealso{
Other user data: \code{\link{trakt.user.collection}};
  \code{\link{trakt.user.followers}};
  \code{\link{trakt.user.following}};
  \code{\link{trakt.user.friends}};
  \code{\link{trakt.user.ratings}};
  \code{\link{trakt.user.stats}};
  \code{\link{trakt.user.watched}}
}

