% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_caption_css.R
\name{add_css_caption}
\alias{add_css_caption}
\title{Add css to tableHTML's caption}
\usage{
add_css_caption(tableHTML, css)
}
\arguments{
\item{tableHTML}{A tableHTML object created by the tableHTML function.}

\item{css}{A list of two elements with the corresponding css. The first element of the list
should be an atomic vector with the style definitions (e.g. background-color). The second
element will be an atomic vector with the same length as the first element, which will 
contain the style definitions' values (e.g. red). Check the examples for more information.}
}
\value{
A tableHTML object.
}
\description{
\code{add_css_caption} will add css to a tableHTML's caption
}
\details{
\code{add_css_caption} will add css to a tableHTML's caption.
}
\examples{
tableHTML(mtcars, caption = 'This is a caption') \%>\% 
  add_css_caption(css = list(c('color', 'font-size'), c('blue', '50px'))) 

tableHTML(mtcars, caption = 'This is a caption') \%>\% 
  add_css_caption(css = list(c('color', 'font-size'), c('blue', '50px'))) \%>\%
  add_css_caption(css = list('background-color', 'green'))

}
