library(stringr)
library(tableschema.r)
library(testthat)
library(foreach)
library(config)

context("types.castList")

# Constants
TESTS <- list(
  list('default', list(), list()),
  list('default', "[]", list()),
  list('default', list('key', 'value'), list('key', 'value')),
  list('default', '["key", "value"]', list('key', 'value')),
  list('default', 'string', config::get("ERROR", file = system.file("config/config.yml", package = "tableschema.r"))),
  list('default', 1, config::get("ERROR", file = system.file("config/config.yml", package = "tableschema.r"))),
  list('default', '3.14', config::get("ERROR", file = system.file("config/config.yml", package = "tableschema.r"))),
  list('default', '', config::get("ERROR", file = system.file("config/config.yml", package = "tableschema.r")))
)

# Tests

foreach(j = seq_along(TESTS) ) %do% {
  
  TESTS[[j]] <- setNames(TESTS[[j]], c("format", "value", "result"))
  
  test_that(str_interp('format "${TESTS[[j]]$format}" should check "${TESTS[[j]]$value}" as "${TESTS[[j]]$result}"'), {
    
    expect_equal(types.castList(TESTS[[j]]$format, TESTS[[j]]$value), TESTS[[j]]$result)
  })
}
