% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constraints.checkRequired.R
\name{constraints.checkRequired}
\alias{constraints.checkRequired}
\title{Check if a field is required}
\usage{
constraints.checkRequired(constraint, value)
}
\arguments{
\item{constraint}{set TRUE to check required values}

\item{value}{value to check}
}
\value{
TRUE if field is required
}
\description{
Indicates whether this field is allowed to be \code{NULL}. 
If required is \code{TRUE}, then \code{NULL} is disallowed.
See the section on \href{https://specs.frictionlessdata.io//table-schema/#missing-values}{missingValues} for how, 
in the physical representation of the data, strings can represent \code{NULL} values.
}
\examples{

constraints.checkRequired(constraint = FALSE, value = 1)

constraints.checkRequired(constraint = TRUE, value = 0)

constraints.checkRequired(constraint = TRUE, value = NULL)

constraints.checkRequired(constraint = TRUE, value = "undefined")

}
\seealso{
\href{https://specs.frictionlessdata.io//table-schema/#constraints}{Constraints specifications}
}
