% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lp_render.R
\name{tab}
\alias{tab}
\alias{render_tab}
\alias{render_score}
\alias{render_midi}
\title{Render sheet music with LilyPond}
\usage{
tab(
  score,
  file,
  key = "c",
  time = "4/4",
  tempo = "2 = 60",
  header = NULL,
  paper = NULL,
  string_names = NULL,
  endbar = TRUE,
  midi = TRUE,
  colors = NULL,
  crop_png = TRUE,
  transparent = FALSE,
  res = 150,
  keep_ly = FALSE,
  simplify = TRUE,
  details = FALSE
)

render_tab(
  score,
  file,
  key = "c",
  time = "4/4",
  tempo = "2 = 60",
  header = NULL,
  paper = NULL,
  string_names = NULL,
  endbar = TRUE,
  midi = TRUE,
  colors = NULL,
  crop_png = TRUE,
  transparent = FALSE,
  res = 150,
  keep_ly = FALSE,
  simplify = TRUE,
  details = FALSE
)

render_score(
  score,
  file,
  key = "c",
  time = "4/4",
  tempo = "2 = 60",
  header = NULL,
  paper = NULL,
  endbar = TRUE,
  colors = NULL,
  crop_png = TRUE,
  transparent = FALSE,
  res = 150,
  keep_ly = FALSE,
  simplify = TRUE,
  details = FALSE
)

render_midi(score, file, key = "c", time = "4/4", tempo = "2 = 60")
}
\arguments{
\item{score}{a score object.}

\item{file}{character, output file ending in .pdf or .png for sheet music or
tablature for \code{score}. May include an absolute or relative path.
For \code{render_midi}, a file ending in .mid.}

\item{key}{character, key signature, e.g., \code{c}, \code{b_}, \code{f#m},
etc.}

\item{time}{character, defaults to \code{"4/4"}.}

\item{tempo}{character, defaults to \code{"2 = 60"}. Set to \code{NULL} to
suppress display of the time signature in the output.}

\item{header}{a named list of arguments passed to the header of the
LilyPond file. See \code{lilypond} for details.}

\item{paper}{a named list of arguments for the LilyPond file page layout.
See \code{lilypond} for details.}

\item{string_names}{label strings at beginning of tab staff. \code{NULL}
(default) for non-standard tunings only, \code{TRUE} or \code{FALSE} for
force on or off completely.}

\item{endbar}{character, the end bar.}

\item{midi}{logical, output midi file in addition to sheet music.}

\item{colors}{a named list of LilyPond element color overrides. See
\code{lilypond} for details.}

\item{crop_png}{logical, see \code{lilypond} for details.}

\item{transparent}{logical, transparent background, png only.}

\item{res}{numeric, resolution, png only. \code{transparent = TRUE} may fail
when \code{res} exceeds ~150.}

\item{keep_ly}{logical, keep the intermediary LilyPond file.}

\item{simplify}{logical, uses \code{simplify_phrase} to convert to simpler,
more efficient LilyPond syntax for the LilyPond file before rendering it.}

\item{details}{logical, set to \code{TRUE} to print LilyPond log output to
console. Windows only.}
}
\value{
nothing returned; a file is written.
}
\description{
Render sheet music/tablature from a music score with LilyPond.
}
\details{
Generate a pdf or png of a music score using the LilyPond music engraving
program.
Output format is inferred from \code{file} extension. This function is a
wrapper around \code{\link{lilypond}}, the function that creates the
LilyPond (\code{.ly}) file.

\code{render_score} renders \code{score} to pdf or png. \code{render_midi}
renders a MIDI file based on \code{score}. This is still done via LilyPond.
The sheet music is created automatically in the process behind the scenes
but is deleted and only the MIDI output is retained.

The original \code{tab} or \code{render_tab} (equivalent) produces both the
sheet music and the MIDI file output by default and includes other arguments
such as the tablature-relevant argument \code{string_names}.
This is the all-purpose function. Also use this when you intend to create
both a sheet music document and a MIDI file.

Remember that whether a track contains a tablature staff, standard music
staff, or both, is defined in each individual track object contained in
\code{score}. It is the contents you have assembled in
\code{score} that dictate what render function you should use.
\code{render_tab} is general and always works, but \code{render_score} would
not be the best choice when a tablature staff is present unless you accept
the default string naming convention.

\code{render_midi} is different from \code{midily} and \code{miditab}, whose
purpose is to create sheet music from an existing MIDI file using a LilyPond
command line utility.

For Windows users, add the path to the LilyPond executable to the system
path variable. For example, if the file is at
\code{C:/Program Files (x86)/LilyPond/usr/bin/lilypond.exe},
then add \code{C:/Program Files (x86)/LilyPond/usr/bin} to the system path.
}
\examples{
if(tabr_options()$lilypond != ""){
  x <- phrase("c ec'g' ec'g'", "4 4 2", "5 432 432")
  x <- track(x)
  x <- score(x)
  outfile <- file.path(tempdir(), "out.pdf")
  tab(x, outfile) # requires LilyPond installation
}
}
\seealso{
\code{\link{lilypond}}, \code{\link{render_chordchart}},
\code{\link{miditab}}
}
