% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reorganise.R
\name{reorganise}
\alias{reorganise}
\title{Reorganise a table}
\usage{
reorganise(input = NULL, schema = NULL)
}
\arguments{
\item{input}{[\code{data.frame(1)}]\cr table to reorganise.}

\item{schema}{[\code{symbol(1)}]\cr the schema description for reorganising
\code{input}.}
}
\value{
A (tidy) table which is the result of employing \code{schema} on
  \code{input}.
}
\description{
This function takes a disorganised messy table and rearranges columns and
rows into a tidy dataset that can be sorted into the areal database.
}
\examples{

# read in a disorganised messy dataset
library(readr)
ds <- system.file("test_datasets", package = "tabshiftr")
input <- read_csv(file = paste0(ds, "/table13.csv"),
                  col_names = FALSE, col_types = cols(.default = "c"))
input

# put together schema description (see makeSchema function)
mySchema <- makeSchema(schema = list(
  clusters =
    list(row = c(1, 8, 8), col = c(1, 1, 4), width = 3, height = 6,
         id = "territories"),
  header = list(row = 1, rel = TRUE),
  variables =
    list(territories =
           list(type = "id", row = 1, col = 1, rel = TRUE),
         year =
           list(type = "id", row = c(3:6), col = 4, dist = TRUE),
         commodities =
           list(type = "id", col = 1, rel = TRUE),
         harvested =
           list(type = "measured", unit = "ha", factor = 1,
                col = 2, rel = TRUE),
         production =
           list(type = "measured", unit = "t", factor = 1,
                col = 3, rel = TRUE))
))

# get the tidy output
reorganise(input, mySchema)
}
