% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{SpaceTime-class}
\alias{SpaceTime-class}
\alias{.SpaceTime}
\title{Space and Time}
\description{
An S4 class to represent space-time informations.
}
\section{Slots}{

\describe{
\item{\code{dates}}{A two column \code{\link{numeric}} matrix giving
the date \code{value} and \code{error}, respectively.}

\item{\code{coordinates}}{A three columns \code{\link{numeric}} matrix
(\code{x}, \code{y} and \code{z}) giving the geographic coordinates
(longitude, latitude and elevation, respectively).}

\item{\code{epsg}}{An \code{\link{integer}} giving the EPSG code of the spatial
reference system used. Numeric values are coerced to \code{\link{integer}}
as by \code{\link{as.integer}} (and hence truncated towards zero).}
}}

\section{Get and set}{

 In the code snippets below, \code{x} is a \code{SpaceTime} object.
 \describe{
  \item{\code{get_dates(x)}, \code{set_dates(x) <- value}}{Get or set the dates
  of \code{x} according to \code{value}
  (see \code{\link[=set_dates<-]{set_dates}} for details).}
  \item{\code{get_coordinates(x)}, \code{set_coordinates(x) <- value}}{Get or
  set the geographical coordinates of \code{x} according to \code{value}
  (see \code{\link[=set_coordinates<-]{set_coordinates}} for details).}
  \item{\code{get_epsg(x)}, \code{set_epsg(x) <- value}}{Get or
  set the EPSG of \code{x} according to \code{value}. Numeric values are
  coerced to \code{\link{integer}} as by \code{\link{as.integer}} (and hence
  truncated towards zero).}
  \item{\code{get_features(x)}}{Convert an \code{AbundanceMatrix}
  object to a \code{\link[=data.frame]{data frame}} with dates and
  coordinates columns.}
 }
}

\author{
N. Frerebeau
}
\keyword{internal}
