% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/extract.R
\docType{methods}
\name{access}
\alias{access}
\alias{get}
\alias{set}
\alias{get_id}
\alias{get_id-method}
\alias{get_totals}
\alias{get_totals-method}
\alias{set_totals<-}
\alias{set_totals-method}
\alias{get_id,ANY-method}
\alias{get_totals,FrequencyMatrix-method}
\alias{set_totals<-,FrequencyMatrix-method}
\alias{set_totals,FrequencyMatrix-method}
\title{Get or Set Parts of an Object}
\usage{
get_id(object)

get_totals(object)

set_totals(object) <- value

\S4method{get_id}{ANY}(object)

\S4method{get_totals}{FrequencyMatrix}(object)

\S4method{set_totals}{FrequencyMatrix}(object) <- value
}
\arguments{
\item{object}{An object from which to get or set element(s).}

\item{value}{A possible value for the element(s) of \code{object} (see
below).}
}
\value{
An object of the same sort as \code{object} with the new values assigned.
}
\description{
Getters and setters to extract or replace parts of an object.
}
\examples{
## Create a count data matrix
A1 <- CountMatrix(data = sample(0:10, 100, TRUE),
                  nrow = 10, ncol = 10, byrow = TRUE)

## Access
get_id(A1)
dim(A1) # Get the matrix dimensions
colnames(A1) # Get the column names
colnames(A1) <- letters[11:20] # Set the column names
rownames(A1) # Get the rownames
rownames(A1) <- LETTERS[1:10] # Set the row names

## Subset
A1[["id"]] # Get the matrix ID
A1[, ] # Get all values
A1[1, ] # Get the first row
A1[c("A", "B", "C"), ] # Get the first three rows
A1[c("A", "B", "C"), 1] # Get the first three rows of the first column
A1[, 1, drop = FALSE] # Get the first column

## Coerce counts to frequencies
B <- as_frequency(A1)
## Row sums are internally stored before coercing to a frequency matrix
get_totals(B) # Get row sums
## This allows to restore the source data
A2 <- as_count(B)
all(A1 == A2)
}
\author{
N. Frerebeau
}
