% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tactile.theme.R
\name{tactile.theme}
\alias{tactile.theme}
\title{Tactile Theme}
\usage{
tactile.theme(fontsize = c(12, 8), color = TRUE, ...)
}
\arguments{
\item{fontsize}{A vector of two numeric scalars for text and symbols
respectively.}

\item{color}{Colorized theme.}

\item{...}{Additional named options.}
}
\value{
A list of graphical parameters that for instance could be supplied
inside a call to \code{\link[lattice:xyplot]{lattice::xyplot()}} or set via
\code{\link[lattice:lattice.options]{lattice::lattice.options()}}.
}
\description{
A custom theme for lattice that tries to make away with some of the
(in this author's opinion) excessive margins that result from the default
settings. It also provides a different color theme based partly on
\code{\link[latticeExtra:custom.theme]{latticeExtra::custom.theme()}}.
}
\details{
The theme currently modifies the default lattice theme so that
\itemize{
\item paddings (margins) are minimized,
\item axis tick lengths are halved, and
\item title size is decreased \emph{slightly}.
}
}
\examples{
xyplot(speed ~ dist, data = cars, par.settings = tactile.theme())
opars <- trellis.par.get()
trellis.par.set(tactile.theme())
show.settings()
trellis.par.set(opars)
}
