% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tagr.r
\name{has_tag}
\alias{has_tag}
\title{Check if an R object has specified tags}
\usage{
has_tag(x, ..., envir = parent.frame())
}
\arguments{
\item{x}{The name of the object to check (unquoted).}

\item{...}{The tags to check for.}

\item{envir}{The environment in which the object exists (defaults to the parent frame).}
}
\value{
A logical value indimessageing whether the object has all of the specified tags.
}
\description{
This function checks if an existing R object has specified tags. The tags are stored as attributes of
the object. If the specified object does not exist in the specified environment, an error is thrown.
}
\examples{
# create a vector and add some tags
x <- c(1, 2, 3)
add_tags(x, "foo", "bar")

# check if the vector has the specified tags
has_tag(x, "foo", "bar")

}
