% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Other.R
\name{stdfEmpInt}
\alias{stdfEmpInt}
\title{Integrated empirical stable tail dependence function}
\usage{
stdfEmpInt(ranks, k)
}
\arguments{
\item{ranks}{A \code{n} x 2 matrix, where each column is a permutation of the integers \code{1:n}, representing the ranks computed from a sample of size \code{n}.}

\item{k}{An integer between 1 and \eqn{n - 1}; the threshold parameter in the definition of the empirical stable tail dependence function.#' @return A scalar.}
}
\description{
Analytical implementation of the integral of the bivariate stable tail dependence function over the unit square.
}
\examples{
ranks <- cbind(sample(1:20), sample(1:20))
stdfEmpInt(ranks, k = 5)
}
\references{
Einmahl, J.H.J., Kiriliouk, A., Krajina, A., and Segers, J. (2016). An Mestimator of spatial tail dependence. Journal of the Royal Statistical Society: Series B (Statistical Methodology), 78(1), 275-298.
}

