% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl_out.R
\name{tbl_out}
\alias{tbl_out}
\title{Output Table}
\usage{
tbl_out(list_obj)
}
\arguments{
\item{list_obj}{the name of the tbl_start object previously initialized.}
}
\value{
A tangram.pipe class object with the finalized table as a dataframe added as the most recent element of \code{list_obj}.
}
\description{
Produces a finalized table.
}
\examples{
iris$color <- sample(c("Blue", "Purple"), size=150, replace=TRUE)
iris$Stem.Size <- sample(c("Small", "Medium", "Medium", "Large"), size=150, replace=TRUE)
iris$Leaf.Color <- "Green"
x <- tbl_start(iris, "Species", missing=TRUE, overall=TRUE, comparison=TRUE) \%>\%
  num_row("Sepal.Length", rowlabels="Sepal Length") \%>\%
  empty_row() \%>\%
  num_row("Sepal.Width", rowlabels="Sepal Width") \%>\%
  empty_row() \%>\%
  num_row("Petal.Length", rowlabels="Petal Length") \%>\%
  empty_row() \%>\%
  num_row("Petal.Width", rowlabels="Petal Width") \%>\%
  empty_row() \%>\%
  cat_row("Stem.Size", rowlabels="Stem Size") \%>\%
  empty_row() \%>\%
  binary_row("color", rowlabels="Color") \%>\%
  tbl_out()
}
\keyword{tangram.pipe}
