% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_network.R
\name{tar_network}
\alias{tar_network}
\title{Return the vertices and edges of a pipeline dependency graph.}
\usage{
tar_network(
  targets_only = FALSE,
  reporter = "silent",
  callr_function = callr::r,
  callr_arguments = targets::callr_args_default(callr_function, reporter)
)
}
\arguments{
\item{targets_only}{Logical, whether to restrict the output to just targets
(\code{FALSE}) or to also include imported global functions and objects.}

\item{reporter}{Character of length 1, name of the reporter to user.
Controls how messages are printed as targets are checked. Choices:
\itemize{
\item \code{"silent"}: print nothing.
\item \code{"forecast"}: print running totals of the checked and outdated
targets found so far.
}}

\item{callr_function}{A function from \code{callr} to start a fresh clean R
process to do the work. Set to \code{NULL} to run in the current session
instead of an external process (but restart your R session just before
you do in order to clear debris out of the global environment).
\code{callr_function} needs to be \code{NULL} for interactive debugging,
e.g. \code{tar_option_set(debug = "your_target")}.
However, \code{callr_function} should not be \code{NULL} for serious
reproducible work.}

\item{callr_arguments}{A list of arguments to \code{callr_function}.}
}
\value{
A list with two data frames: \code{vertices} and \code{edges}. The
vertices data frame has one row per target with fields to denote
the type of the target or object (stem, branch, map, cross, function,
or object) and the target's status
(up to date, outdated, running, canceled, or errored).
The edges data frame has one row for every edge and columns \code{to} and
\code{from} to mark the starting and terminating vertices.
}
\description{
Analyze the pipeline defined in \verb{_targets.R}
and return the vertices and edges of the directed acyclic graph
of dependency relationships.
}
\examples{
if (identical(Sys.getenv("TAR_LONG_EXAMPLES"), "true")) {
tar_dir({ # tar_dir() runs code from a temporary directory.
tar_script({
  tar_option_set()
  list(
    tar_target(y1, 1 + 1),
    tar_target(y2, 1 + 1),
    tar_target(z, y1 + y2)
  )
}, ask = FALSE)
tar_network(targets_only = TRUE)
})
}
}
