% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_canceled.R
\name{tar_canceled}
\alias{tar_canceled}
\title{List canceled targets.}
\usage{
tar_canceled(names = NULL, store = targets::tar_config_get("store"))
}
\arguments{
\item{names}{Optional, names of the targets. If supplied, the
function restricts its output to these targets.
You can supply symbols
or \code{tidyselect} helpers like \code{\link[=any_of]{any_of()}} and \code{\link[=starts_with]{starts_with()}}.}

\item{store}{Character of length 1, path to the
\code{targets} data store. Defaults to \code{tar_config_get("store")},
which in turn defaults to \verb{_targets/}.
When you set this argument, the value of \code{tar_config_get("store")}
is temporarily changed for the current function call.
See \code{\link[=tar_config_get]{tar_config_get()}} and \code{\link[=tar_config_set]{tar_config_set()}} for details
about how to set the data store path persistently
for a project.}
}
\value{
A character vector of canceled targets.
}
\description{
List targets whose progress is \code{"canceled"}.
}
\examples{
if (identical(Sys.getenv("TAR_EXAMPLES"), "true")) { # for CRAN
tar_dir({ # tar_dir() runs code from a temp dir for CRAN.
tar_script({
  list(
    tar_target(x, seq_len(2)),
    tar_target(y, 2 * x, pattern = map(x))
  )
}, ask = FALSE)
tar_make()
tar_canceled()
tar_canceled(starts_with("y_")) # see also any_of()
})
}
}
\seealso{
Other progress: 
\code{\link{tar_built}()},
\code{\link{tar_errored}()},
\code{\link{tar_poll}()},
\code{\link{tar_progress_branches}()},
\code{\link{tar_progress_summary}()},
\code{\link{tar_progress}()},
\code{\link{tar_skipped}()},
\code{\link{tar_started}()},
\code{\link{tar_watch_server}()},
\code{\link{tar_watch_ui}()},
\code{\link{tar_watch}()}
}
\concept{progress}
