% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_latex.R
\name{as_latex}
\alias{as_latex}
\alias{save_pdf}
\alias{view_pdf}
\title{Convert a Table to Latex Code}
\usage{
as_latex(x, ..., kable_options = default_kable_options())

save_pdf(x, outfile, ..., overwrite = FALSE, papersize = "a4paper",
  orientation = "portrait", keep_source = FALSE,
  template = system.file("templates", "save_tex.Rmd", package = "tatoo"))

view_pdf(x, ...)
}
\arguments{
\item{x}{a \code{\link{Tatoo_table}}, \code{data.frame} or a list of \code{data.frame}s}

\item{...}{passed on to methods}

\item{kable_options}{\code{list}. Options passed on to \code{\link[knitr:kable]{knitr::kable()}}. See
\code{\link[=default_kable_options]{default_kable_options()}} for details.}

\item{outfile}{\code{character} scalar. Path to the output file}

\item{overwrite}{If \code{TRUE}, overwrite any existing file.}

\item{papersize}{\code{character} scalar. Passed on to the latex command
\code{\\geometry} from the 'geometry' package. Valid values are: \code{a0paper, a1paper, a2paper, a3paper, a4paper, a5paper, a6paper, b0paper, b1paper, b2paper, b3paper, b4paper, b5paper, b6paper, c0paper, c1paper, c2paper, c3paper, c4paper, c5paper, c6paper, b0j, b1j, b2j, b3j, b4j, b5j, b6j, ansiapaper, ansibpaper, ansicpaper, ansidpaper, ansiepaper, letterpaper, executivepaper, legalpaper}}

\item{orientation}{\code{character} scalar. Passed on to the latex command
\code{\\geometry} from the 'geometry' package. Valid values are:
\code{portrait}, \code{landscape}}

\item{keep_source}{When saving a \file{pdf}, also put the Latex source
in the same directory.}

\item{template}{Latex template for the desired output. Use the template
file supplied in this package if you want to create your own.}
}
\value{
\code{as_latex()}returns a \code{character} scalar of Latex code

\code{save_pdf()} returns a the path to the saved file as \code{character}
scalar.

\code{view_pdf()} returns \code{NULL} (invisibly)
}
\description{
\code{as_latex()} converts an \R Object (currently \code{\link{Tatoo_table}}s and
\code{data.frame}s) to latex code.

\code{save_pdf()} is a wrapper around \code{as_latex()} for directly saving
an \R object to \file{.pdf}.

\code{view_pdf()} is another wrapper for directly viewing an \R
Object's pdf representation on a pdf viewer (powered by \code{\link[=open_file]{open_file()}}).
}
\details{
\code{as_latex()} and co. are designed to produce nice looking output with a
minimum of user input required. This is useful if you want a quick preview
or printout of a table.  If you need customized Latex the output, you
should take a look at the packages \link[kableExtra:kableExtra]{kableExtra::kableExtra}, \strong{xtable}, or \strong{huxtable}.
}
\section{Latex Packages}{

\code{as_latex} requires that the following Latex packages are installed on your
system:\preformatted{\usepackage{booktabs}
\usepackage{longtable}
\usepackage{threeparttablex}
}
}

\examples{
  as_latex(iris)

\dontrun{
  view_pdf(iris)  # Not supported on all systems
}


}
\seealso{
Other as_latex methods: \code{\link{as_latex.Composite_table}},
  \code{\link{as_latex.Mashed_table}},
  \code{\link{as_latex.Tagged_table}},
  \code{\link{as_latex.Tatoo_report}},
  \code{\link{as_latex.data.frame}}
}
