% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxonomy--docs.R
\name{get_data_frame}
\alias{get_data_frame}
\title{Get data in a taxonomy or taxmap object by name}
\arguments{
\item{obj}{A \code{\link[=taxonomy]{taxonomy()}} or \code{\link[=taxmap]{taxmap()}}  object}

\item{name}{(\code{character}) Names of data to return. If not supplied, return
all data listed in \code{\link[=all_names]{all_names()}}.}

\item{...}{Passed to \code{\link[=all_names]{all_names()}}. Used to filter what kind of data is
returned (e.g. columns in tables or function output?) if \code{name} is not
supplied or what kinds are allowed if \code{name} is supplied.}
}
\value{
\code{data.frame}
}
\description{
Given a vector of names, return a  table of the indicated data
contained in a \code{\link[=taxonomy]{taxonomy()}} or \code{\link[=taxmap]{taxmap()}} object.
\preformatted{
obj$get_data_frame(name = NULL, ...)
get_data_frame(obj, name = NULL, ...)}
}
\details{
Note: This function will not work with variables in datasets in \code{\link[=taxmap]{taxmap()}}
objects unless their rows correspond 1:1 with all taxa.
}
\examples{
# Get specific values
get_data_frame(ex_taxonomy, c("taxon_names", "taxon_indexes", "is_stem"))

# Get all values
get_data_frame(ex_taxonomy)

}
\seealso{
Other accessors: \code{\link{all_names}},
  \code{\link{data_used}}, \code{\link{get_data}},
  \code{\link{names_used}}
}
