% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tl_import.R
\name{tl_import}
\alias{tl_import}
\title{Import taxonomic database tables}
\usage{
tl_import(
  provider = getOption("tl_default_provider", "itis"),
  schema = "dwc",
  version = tl_latest_version(),
  prov = paste0("https://raw.githubusercontent.com/",
    "boettiger-lab/taxadb-cache/master/prov.json")
)
}
\arguments{
\item{provider}{Abbreviation for a known naming provider.
Provider data should first be imported with \verb{[tl_create]}.
Note: setting provider to \code{"itis_test"} is for testing purposes only,
use \code{"itis"} for the full ITIS data.  See details}

\item{schema}{schema to import from}

\item{version}{version of the authority to use (e.g. four-digit year)}

\item{prov}{Address (URL) to provenance record}
}
\value{
path(s) to the downloaded files in the cache
}
\description{
Downloads the requested taxonomic data tables and return a local path
to the data in \code{tsv.gz} format.  Downloads are cached and identified by
content hash so that \code{tl_import} will not attempt to download the
same file multiple times.
\code{tl_import} parses a PROV record to determine the correct version to download.
If offline, \code{tl_import} will attempt to resolve against its own cached
provenance record.
}
\details{
\code{tl_import} parses a DCAT2/PROV-O record to determine the correct version
to download. If offline, \code{tl_import} will attempt to resolve against
it's own provenance cache. Users can also examine / parse the prov
JSON-LD file directly to determine the provenance of the data products
used.
}
