% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbma.R
\name{tbma}
\alias{tbma}
\title{Tree-based Moving Average (tbma)}
\usage{
tbma(
  formula,
  train,
  test,
  prediction_type = "point",
  percentile = c(0.25, 0.5, 0.75),
  group_id = NULL,
  horizon = nrow(train),
  splitrule = "extratrees",
  always_split_variables = NULL,
  min_node_size = 5,
  max_depth = NULL,
  num_trees = 100,
  ma_order = 2,
  mtry = round(sqrt(ncol(train)))
)
}
\arguments{
\item{formula}{Object of class formula}

\item{train}{A data.table object}

\item{test}{A data.table object}

\item{prediction_type}{Prediction type can be either "point" or "probabilistic". In case of "probabilistic", percentiel parameter is required.}

\item{percentile}{Percentile of the probabilistic forecasts if the prediction type is "probabilistic". Percentile paramater can take multiple values between 0 and 1 in a vector.}

\item{group_id}{Gorup identity parameter is required to filter the data that is going to be used for prediction of a test observations. Group identity parameter is optional to use and usually one of the categorical variables has significant effect on the response variable.}

\item{horizon}{Horizon parameter filters the train data that is going to be used for forecasting a test observations. The last n train observation is used for forecasting in case of horizon is n. Default value is number of observations in the train set which means no filtering.}

\item{splitrule}{Splitrule determines the process of splitting. It can be "extratrees","variance", or "maxstat". See the documentation of the 'ranger' package for details.}

\item{always_split_variables}{Vector of column names indicating the colums that should be selected as candidate variables for splitting. See the documentation of the 'ranger' package for details.}

\item{min_node_size}{Minimum node size allowed in terminal nodes of decesion trees.}

\item{max_depth}{Maximum depth of decision trees. See the documentation of the 'ranger' package for details.}

\item{num_trees}{Number of trees}

\item{ma_order}{Order of the movinh average part of the TBMA model. Default is 2. High order parameter can lead NA forecasts.}

\item{mtry}{Number of variables selected as candidate varibles for splitting. See the documentation of the 'ranger' package for details.}
}
\value{
A data.table object. In case of point forecasting, a column called "prediction" is added to the data table that contains the columns mentioned in the formula. In case of probabilistic forecasting, columns named with the percentile values are added to thr data table that contains the columns mentioned in the formula.
}
\description{
The tbma() function is used for forecasting problems with predictors. With the help of integrating the moving average approach to tree-based ensemble approach, the function handles the correlations and autocorrelations in time series data. The tree-based ensemble models in the tbma() function is provided by the ranger() function from the 'ranger' package (Marvin N. Wright & Andreas Ziegler, 2017).
}
\examples{
library(datasets)
library(data.table)
data(airquality)
summary(airquality)
airquality<-as.data.table(airquality)
airquality[complete.cases(airquality)]
train <- airquality[1:102,]
test <- airquality[103:nrow(airquality), ]
test_data_with_predictions<-tbma(Temp ~ .,train = train,test = test,
prediction_type = "point",horizon=100,ma_order = 2)

}
\references{
\itemize{
  \item Wright, M. N. & Ziegler, A. (2017). ranger: A fast implementation of random forests for high dimensional data in C++ and R. J Stat Softw 77:1-17. \url{https://doi.org/10.18637/jss.v077.i01}.
  \item Matt Dowle and Arun Srinivasan (2019). data.table: Extension of `data.frame`. R package version 1.12.8. \url{https://CRAN.R-project.org/package=data.table}
  }
}
