% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbr_mean.R
\name{tbr_mean}
\alias{tbr_mean}
\title{Time-Based Rolling Mean}
\usage{
tbr_mean(.tbl, x, tcolumn, unit = "years", n, ...)
}
\arguments{
\item{.tbl}{a data frame with at least two variables; time column formatted as date, date/time and value column.}

\item{x}{column containing the numeric values to calculate the mean.}

\item{tcolumn}{formatted time column.}

\item{unit}{character, one of "years", "months", "weeks", "days", "hours", "minutes", "seconds"}

\item{n}{numeric, describing the length of the time window.}

\item{...}{additional arguments passed to \code{\link{mean_ci}}.}
}
\value{
tibble with columns for the rolling mean and upper and lower confidence intervals.
}
\description{
Produces a a rolling time-window based vector of means and confidence intervals.
}
\examples{
## Return a tibble with new rolling mean column
tbr_mean(Dissolved_Oxygen, x = Average_DO, tcolumn = Date, unit = "years", n = 5)

\dontrun{
## Return a tibble with rolling mean and 95\% CI
tbr_mean(Dissolved_Oxygen, x = Average_DO, tcolumn = Date, unit = "years", n = 5, conf = .95)}
}
\seealso{
\code{\link{mean_ci}}
}
