% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tcplCode2CASN.R
\name{tcplCode2CASN}
\alias{tcplCode2CASN}
\title{Convert chemical code to CAS Registry Number}
\usage{
tcplCode2CASN(code)
}
\arguments{
\item{code}{Character of length 1, a chemical code}
}
\value{
A CAS Registry Number.
}
\description{
\code{tcplCode2CASN} takes a code and converts it CAS Registry Number.
}
\details{
The function checks for the validity of the CAS Registry Number. Also, 
the ToxCast data includes chemcials for which there is no CASRN. The 
convention for these chemicals is to give them a CASRN as NOCAS_chid; the
code for these compounds is CNOCASchid. The function handles the NOCAS 
compounds as they are stored in the database, as shown in the exmaple below.
}
\examples{
tcplCode2CASN("C80057")
tcplCode2CASN("C09812420") ## Invalid CASRN will give a warning
tcplCode2CASN("CNOCAS0015") ## The underscore is reinserted for NOCAS codes

}

