% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tcplMakeAeidPlts.R
\name{tcplMakeAeidPlts}
\alias{tcplMakeAeidPlts}
\title{Create a .pdf with dose-response plots}
\usage{
tcplMakeAeidPlts(aeid, lvl = 4L, fname = NULL, odir = getwd(),
  ordr.fitc = TRUE, clib = NULL)
}
\arguments{
\item{aeid}{Integer of length 1, the assay endpoint id}

\item{lvl}{Integer of lengh 1, the data level to use (4-6)}

\item{fname}{Character, the filename}

\item{odir}{The directory to save the .pdf file in}

\item{ordr.fitc}{Logical, should the fits be ordered by fit category?}

\item{clib}{Character, the chemical library to subset on, see 
\code{\link{tcplLoadClib}} for more information.}
}
\description{
\code{tcplMakeAeidPlts} creates a .pdf file with the dose-response plots for 
the given aeid.
}
\details{
\code{tcplMakeAeidPlts} provides a wrapper for \code{\link{tcplPlotFits}},
allowing the user to produce PDFs with the curve plots without having to 
separately load all of the data and establish the PDF device.

If 'fname' is \code{NULL}, a default name is given by concatenating together
assay information. 

Note, the default value for ordr.fitc is \code{TRUE} in 
\code{tcplMakeAeidPlts}, but \code{FALSE} in \code{tcplPlotFits}
}
\examples{
\dontrun{
## Will produce the same result as the example for tcplPlotFits
tcplMakeAeidPlts(aeid = 1, lvl = 6, ordr.fitc = FALSE)
}

}
