% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tcplPlot.R
\name{tcplPlot}
\alias{tcplPlot}
\title{#-------------------------------------------------------------------------------
 Generic Plotting Function for tcpl}
\usage{
tcplPlot(
  dat = NULL,
  type = "mc",
  fld = "m4id",
  val = NULL,
  compare.val = NULL,
  by = NULL,
  output = c("console", "pdf", "png", "jpg", "svg", "tiff"),
  fileprefix = paste0("tcplPlot_", Sys.Date()),
  multi = NULL,
  verbose = FALSE,
  nrow = NULL,
  ncol = NULL,
  dpi = 600,
  flags = FALSE,
  yuniform = FALSE,
  yrange = c(NA, NA)
)
}
\arguments{
\item{dat}{data.table containing plot-prepared data, used for stand-alone 
(non-ToxCast data like other tcplfit2-fit data) or advanced plotting 
(generating comparison plots across multiple database configurations) and not
required. See \code{tcplPlotLoadData}.}

\item{type}{Character of length 1, the data type, "sc" or "mc".}

\item{fld}{Character, the field(s) to query on.}

\item{val}{List, vectors of values for each field to query on. Must be in
the same order as 'fld'.}

\item{compare.val}{List, vectors of values for each field to query on to 
compare with val. Must be in the same order as 'fld'. Must have the same
length as val (1:1 comparison). Must be set to compare plots; otherwise leave
NULL}

\item{by}{Parameter to divide files into e.g. "aeid".}

\item{output}{How should the plot be presented. To work with the plot in 
environment, use "ggplot"; to interact with the plot in application, use 
"console"; or to save as a file type, use "pdf", "jpg", "png", "svg", or "tiff".}

\item{fileprefix}{Prefix of file when saving.}

\item{multi}{Boolean, by default TRUE for "pdf". If multi is TRUE, output
by  default 4 plots per page for 'verbose' = TRUE and 6 plots per page for
'verbose' = FALSE.}

\item{verbose}{Boolean, by default FALSE. If TRUE, a table with fitting parameters
is included with the plot.}

\item{nrow}{Integer, number of rows in multiplot. By default 2.}

\item{ncol}{Integer, number of columns in multiplot. By default 3, 2 if verbose.}

\item{dpi}{Integer, image print resolution. By default 600.}

\item{flags}{Boolean, by default FALSE. If TRUE, level 6 flags are displayed
below annotations on plot}

\item{yuniform}{Boolean, by default FALSE. If TRUE, all plots will have uniform
y axis scaling, automatically determined.}

\item{yrange}{Integer of length 2, for directly setting the y-axis range, 
c(<min>,<max>). By default, c(NA,NA).}
}
\description{
\code{tcplPlot} queries the tcpl databases and returns a plot
for the given level and data type.
}
\details{
The data type can be either 'mc' for multiple concentration data, or 'sc'
for single concentration data. Multiple concentration data will be loaded
into the 'mc' tables, whereas the single concentration will be loaded into
the 'sc' tables.

Leaving \code{fld} NULL will return all data.
}
\examples{
\dontrun{
tcplPlot(fld = "m4id", val = c(18609966)) ## Create a level 4 plot
}
}
