% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tdROC.R
\name{tdROC}
\alias{tdROC}
\title{Calculate Time-dependent ROC and AUC}
\usage{
tdROC(X, Y, delta, tau, span = 0.1, h = NULL, type = "uniform",
  cut.off = NULL, nboot = 0, alpha = 0.05, n.grid = 1000,
  X.min = NULL, X.max = NULL)
}
\arguments{
\item{X}{a numeric vector of biomarker values. Same length with \code{Y} and \code{delta}.}

\item{Y}{a numeric vector of time to event.Same length with \code{X} and \code{delta}.}

\item{delta}{a vector of binary indicator of event (1) or censoring (0). Same length with \code{X} and \code{Y}.}

\item{tau}{a scalar, the prediction horizon at which the prediction is evaluated.}

\item{span}{a numeric value, the proportion of neighbour observations used in nearest neighbor method, default is 0.1.}

\item{h}{a numeric value, the bandwidth of kernel weights, defualt is \code{NULL}. If not specified, the function will use the value of
\code{span} to calculate kernel weights. In case both \code{span} and \code{h} are specified, the function will use \code{h}.}

\item{type}{a character value, indicating the type of kernel function used to calculate kernel weights. Default is "\code{uniform}" kernel. Other options are "\code{Epanechnikov}" and "\code{normal}".
It will only be used when the bandwidth \code{h} is specified.}

\item{cut.off}{a vector of biomarker cut-off values at which sensitivity and specificity will be calculated.When bootstrap is requested, the corresponding confidence intervals will also be provided.}

\item{nboot}{the number of bootstrap replications to be used for variance estimation; default is \code{nboot = 0}, corresponding to no variance estimation.}

\item{alpha}{\code{1-level of confidence interval}, default is \code{0.05}. It is used only when \code{nboot > 0}.}

\item{n.grid}{an positive integer, the number of grid points used when calculating the ROC curve. The default is \code{1000}.}

\item{X.min}{the lower boundary of grid cut-off points for biomarker \code{X}. If not specified, default will be the minimum of biomarker \code{X}.}

\item{X.max}{the upper boundary of grid cut-off points for biomarker \code{X}. If not specified, default will be the maximum of biomarker \code{X}.
\code{X.min} and \code{X.max} are not needed for point estimate but are needed for bootstrap variance estimation.}
}
\value{
Returns a list of the following items:

\code{ROC:} a data frame of dimension \code{(2+n.grid) x 3}, the three columns are: \code{grid}, \code{sens}, and \code{spec}.

\code{AUC:} a data frame of one row and four columns: \code{AUC}, standard error of \code{AUC}, the lower and upper limits of bootstrap CI.
 \code{AUC} is calculated by integrating the area under ROC curve with trapezoidal method.

\code{AUC2:} a data frame of one row and four columns: \code{AUC2}, standard error of \code{AUC2}, the lower and upper limits of bootstrap CI.
 \code{AUC2} is the AUC calculated by the concordance based formula (Li \emph{et al.}, 2015).

\code{prob:} a data frame of three columns if \code{nboot=0}: \code{cut.off}, \code{sens}, and \code{spec}. If \code{nboot>0}, another six
       columns of standard error, lower and upper limits of both \code{sens} and \code{spec} will be added. The number of rows equals length of \code{cut.off}.
             A series of sensivitity and specificity are calculated at requested \code{cut.off} points.
}
\description{
This is the main function of this package. It calculates the time-dependent
 sensitivity and specificity and area under the curve (AUC) using a nonparametric weighting adjustment.
 It also provides variance estimation through bootstrap.
}
\details{
This function read in the prognostic biomarker value \code{X}, the time-to-event data \code{Y} and censoring indicator \code{delta} to calculate
 the sensitivity and specificity at the prediction horizon \code{tau} for a series specified grid points. It uses a simple
 nonparametric weight adjustments for right censored data (Li \emph{et al.}, 2015).
}
\examples{
library( survival ) ;
data( mayo ) ;
dat <- mayo[ ,c( "time","censor","mayoscore5" )] ;

fm <- tdROC( X = dat$mayoscore5, Y = dat$time, delta = dat$censor,
       tau = 365*6, span = 0.1, nboot = 0, alpha = 0.05,
       n.grid = 1000, cut.off = 5:9 ) ;

}
\author{
Liang Li, Cai Wu
}
\references{
Li, Liang, Bo Hu, and Tom Greene. "A Simple Method to Estimate the Time-dependent ROC Curve Under Right Censoring." (2015).
           \url{http://biostats.bepress.com/cobra/art114/}
}
\seealso{
\code{\link[survival]{survfit}},  \code{\link[survivalROC]{mayo}}
}

