% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/triangles.r
\name{triangles}
\alias{triangles}
\alias{sample_triangle_planar}
\title{Sample (with noise) from planar triangles}
\usage{
sample_triangle_planar(n, triangle, bins = 1, sd = 0)
}
\arguments{
\item{n}{Number of observations.}

\item{triangle}{The (x,y) coordinates of the vertices of a triangle,
formatted in a 2x3 matrix}

\item{bins}{Number of intervals per dimension to stratify by. Default set to
1, which generates a uniform sample.}

\item{sd}{Standard deviation of (independent multivariate) Gaussian noise.}
}
\description{
This function generates uniform and stratified samples from
configurations of planar triangles in 2-dimensional space, optionally with
noise.
}
\details{
The sample is generated by an area-preserving parameterization of
the planar triangle. This parameterization was derived through the method
for sampling 2-manifolds as described by Arvo (2001).
}
\examples{
set.seed(23004L)

#Uniformly sampled equilateral planar triangle in 2-space
equilateral_triangle <- cbind(c(0,0), c(0.5,sqrt(3)/2), c(1,0))
x <-  sample_triangle_planar(10000, equilateral_triangle)
plot(x, asp = 1, pch = 19, cex = .25)

#Stratified sample of equilateral planar triangle in 2-space with 100 bins
equilateral_triangle <- cbind(c(0,0), c(0.5,sqrt(3)/2), c(1,0))
x <-  sample_triangle_planar(10000, equilateral_triangle, bins = 100)
plot(x, asp = 1, pch = 19, cex = .25)

#Uniformly sampled equilateral planar triangle in 2-space with Gaussian noise
equilateral_triangle <- cbind(c(0,0), c(0.5,sqrt(3)/2), c(1,0))
x <-  sample_triangle_planar(10000, equilateral_triangle, sd = .1)
plot(x, asp = 1, pch = 19, cex = .25)
}
\references{
J Arvo (2001) Stratified Sampling of 2-Manifolds. \emph{SIGRAPH 2001 (State of the
Art in Monte Carlo Ray Tracing for Realistic Image Synthesis)}, Course Notes,
Vol. 29. \url{https://www.cs.princeton.edu/courses/archive/fall04/cos526/papers/course29sig01.pdf}
}
