% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qenv-get_var.R
\name{get_var}
\alias{get_var}
\alias{get_var,qenv,character-method}
\alias{get_var,qenv.error,ANY-method}
\alias{[[,qenv,ANY,missing-method}
\alias{[[.qenv.error}
\title{Get object from the \code{qenv} environment}
\usage{
get_var(object, var)

\S4method{get_var}{qenv,character}(object, var)

\S4method{get_var}{qenv.error,ANY}(object, var)

\S4method{[[}{qenv,ANY,missing}(x, i, j, ...)

\method{[[}{qenv.error}(x, i, j, ...)
}
\arguments{
\item{object}{(\code{qenv})}

\item{var}{(\code{character(1)}) name of the variable to pull from the environment.}

\item{x}{(\code{qenv})}

\item{i}{(\code{character}) name of the binding in environment (name of the variable)}

\item{j}{not used}

\item{...}{not used}
}
\value{
The value of required variable (\code{var}) within \code{qenv} object.
}
\description{
Get object from the \code{qenv} environment.
}
\examples{
q1 <- new_qenv(env = list2env(list(a = 1)), code = quote(a <- 1))
q2 <- eval_code(q1, code = "b <- a")
get_var(q2, "b")
q2[["b"]]

}
