% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AddCardModule.R
\name{add_card_button}
\alias{add_card_button}
\alias{add_card_button_ui}
\alias{add_card_button_srv}
\title{Add card button module}
\usage{
add_card_button_ui(id)

add_card_button_srv(id, reporter, card_fun)
}
\arguments{
\item{id}{(\code{character(1)}) this \code{shiny} module's id.}

\item{reporter}{(\code{Reporter}) instance.}

\item{card_fun}{(\code{function}) which returns a \code{\link{ReportCard}} instance. See \code{Details}.}
}
\value{
\code{NULL}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Provides a button to add views/cards to a report.

For more details see the vignette: \code{vignette("simpleReporter", "teal.reporter")}.
}
\details{
The \code{card_fun} function is designed to create a new \code{ReportCard} instance and optionally customize it:
\itemize{
\item The \code{card} parameter allows for specifying a custom or default \code{ReportCard} instance.
\item Use the \code{comment} parameter to add a comment to the card via \code{card$append_text()} - if \code{card_fun} does not
have the \code{comment} parameter, then \code{comment} from \verb{Add Card UI} module will be added at the end of the content of the
card.
\item The \code{label} parameter enables customization of the card's name and its content through \code{card$append_text()}-
if \code{card_fun} does not have the \code{label} parameter, then card name will be set to the name passed in
\verb{Add Card UI} module, but no text will be added to the content of the \code{card}.
}

This module supports using a subclass of \code{\link{ReportCard}} for added flexibility.
A subclass instance should be passed as the default value of
the \code{card} argument in the \code{card_fun} function.
See below:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{CustomReportCard <- R6::R6Class(
  classname = "CustomReportCard",
  inherit = teal.reporter::ReportCard
)

custom_function <- function(card = CustomReportCard$new()) \{
  card
\}
}\if{html}{\out{</div>}}
}
