% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draggable_buckets.R
\name{draggable_buckets}
\alias{draggable_buckets}
\title{Draggable Buckets}
\usage{
draggable_buckets(input_id, label, elements = character(), buckets)
}
\arguments{
\item{input_id}{(\code{character(1)}) the \code{HTML} id of this widget}

\item{label}{(\code{character(1)} or \code{shiny.tag}) the header of this widget}

\item{elements}{(\code{character}) the elements to drag into buckets}

\item{buckets}{(\code{character} or \code{list}) the names of the buckets the elements can be put in or a list of key-pair
values where key is a name of a bucket and value is a character vector of elements in a bucket}
}
\value{
the \code{HTML} code comprising an instance of this widget
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
A custom widget with draggable elements that can be put into buckets.
}
\details{
\code{shinyvalidate} validation can be used with this widget. See example below.
}
\examples{
library(shiny)

ui <- fluidPage(
  draggable_buckets("id", "Choices #1", c("a", "b"), c("bucket1", "bucket2")),
  draggable_buckets("id2", "Choices #2", letters, c("vowels", "consonants")),
  verbatimTextOutput("out"),
  verbatimTextOutput("out2")
)
server <- function(input, output) {
  iv <- shinyvalidate::InputValidator$new()
  iv$add_rule(
    "id",
    function(data) if (length(data[["bucket1"]]) == 0) "There should be stuff in bucket 1"
  )
  iv$enable()

  observeEvent(list(input$id, input$id2), {
    print(isolate(input$id))
    print(isolate(input$id2))
  })
  output$out <- renderPrint({
    iv$is_valid()
    input$id
  })
  output$out2 <- renderPrint(input$id2)
}
if (interactive()) shinyApp(ui, server)

# With default elements in the bucket
ui <- fluidPage(
  draggable_buckets("id", "Choices #1", c("a", "b"), list(bucket1 = character(), bucket2 = c("c"))),
  verbatimTextOutput("out")
)
server <- function(input, output) {
  observeEvent(input$id, {
    print(isolate(input$id))
  })
  output$out <- renderPrint(input$id)
}
if (interactive()) shinyApp(ui, server)
}
