% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.stData.R
\name{plot.stData}
\alias{plot.stData}
\title{Plot stData objects}
\usage{
\method{plot}{stData}(x, type = "response", t = NULL, p = NULL,
  map = "world", region = ".", coord.s = NULL, coord.r = NULL,
  zlim = NULL, fill.lab = NULL,
  lab.teleconnection = expression(alpha), fill.lab.width = 20,
  category.breaks = NULL, coords.knots = NULL, signif.telecon = F,
  dots = NULL, pattern = 1, lwd = 1.75, cutoff = 0.9,
  signif.level = 0.05, alpha = 0.2, zmid = 0, contour = c(F, F),
  ...)
}
\arguments{
\item{x}{Object of class stData to plot.}

\item{type}{One of the following options to specify what type of plot to build
\describe{
  \item{response}{  }
  \item{sd.response}{ Plot standard deviation of response variable at each location. }
  \item{cat.response}{  }
  \item{covariate}{  }
  \item{remote}{  }
  \item{teleconnection}{ This plot only applies if the stData object 
  contains information about teleconnection effects,
  i.e., if it is a simulated dataset or otherwise modified to include 
  estimates of teleconnection effects. }
  \item{remote_cor}{ This plot shows pointwise correlations between a local
   coordinate and the remote covariates.  }
  \item{eof}{  }
  \item{eof_scores}{  }
  \item{eof_scree}{ }
  \item{eof_cor}{ This plot shows pointwise correlations with EOF patterns. }
  \item{local_cor}{ This plot shows pointwise correlations with local covariates. }
  \item{teleconnection_knot_local}{ }
}}

\item{t}{timepoint to plot.  Will automatically plot the first timepoint if
t=NULL.}

\item{p}{column index of local covariate to plot if type='covariate'. Will 
automatically assume the local covariate data includes an intercept and will
plot the second column if p=NULL.}

\item{map}{name of map provided by the maps package. These include county, 
france, italy, nz, state, usa, world, world2.  By default, all stData plots
will include us state outlines.}

\item{region}{name of subregions to include. Defaults to . which includes 
all subregions. See documentation for map for more details.}

\item{coord.s}{if plot type is 'teleconnection', specifies the longitude and 
latitude of local coordinate for which to plot teleconnection effects. if 
NULL, the middle local coordinate will be plotted.}

\item{coord.r}{if plot type is 'teleconnection_local', specifes the longitude
and latitude of remote coordinate for which to plot associated teleconnection
effects.  if NULL, the middle remote coordinate will be plotted.}

\item{zlim}{c(min, max) vector that specifies the colorscale limits}

\item{fill.lab}{Optional label to override the default fill scale labels}

\item{lab.teleconnection}{label used for fill scale in teleconnection plot}

\item{fill.lab.width}{line width for fill scale label}

\item{category.breaks}{[ncoords x ncats] list of breakpoints used for binning
responses into categories}

\item{coords.knots}{if plot type is 'remote', specifies the longitude and
latitude of knot locations to overlay on the 'remote' plot}

\item{signif.telecon}{if TRUE, will highlight significant grid cells if the
plotting data contain a signif column}

\item{dots}{additional named arguments with defaults to pass to additional 
functions}

\item{pattern}{if type=='eof' this specifies which (remote) EOF pattern to plot
or if type=='eof_scores' this (vector) specifies which (remote) EOF pattern
scores to plot}

\item{lwd}{line width for when plotting with signif.telecon==T}

\item{cutoff}{Used to denote where this proportion of variance is achieved in
the eof_scree plots}

\item{signif.level}{significance level for eof_cor significance highlighting}

\item{alpha}{the level of fading that should be applied to insignificant
grid boxes when plotting significant effects}

\item{zmid}{number that specifies the midpoint of the colorscale}

\item{contour}{c(TRUE, TRUE) to plot local and remote responses as contours
vs. observations}

\item{...}{additional arguments to pass to functions}
}
\value{
a ggplot object with the specified map
}
\description{
This function provides basic plotting for telefit package data.
}
\examples{

data("coprecip")
p = plot(coprecip)

}
