% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replymarkup.R
\name{ForceReply}
\alias{ForceReply}
\title{Display a reply}
\usage{
ForceReply(force_reply = TRUE, selective = NULL)
}
\arguments{
\item{force_reply}{Shows reply interface to the user, as if they manually
selected the bot's message and tapped 'Reply'. Defaults to \code{TRUE}.}

\item{selective}{(Optional). Use this parameter if you want to show the keyboard
to specific users only.}
}
\description{
Upon receiving a message with this object, Telegram clients will display
a reply interface to the user (act as if the user has selected the bot's
message and tapped 'Reply').
}
\examples{
\dontrun{
# Initialize bot
bot <- Bot(token = "TOKEN")
chat_id <- "CHAT_ID"

# Set input parameters
text <- "Don't forget to send me the answer!"

# Send reply message
bot$sendMessage(chat_id, text, reply_markup = ForceReply())
}
}
