% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/t2d.R
\name{simulate_t2d}
\alias{simulate_t2d}
\title{TELEMAC-2D model run}
\usage{
simulate_t2d(x, log = "run.log", res = NULL, vars = "all", exec)
}
\arguments{
\item{x}{An object of class \code{t2d}.}

\item{log}{\code{character}, a filename for logging of runtime messages to be
created in the project directory (\code{x$wdir}). Default: \code{run.log}. Set to
\code{NULL} if no logfile shall be created (in that case the runlog will not be
checked for errors).}

\item{res}{\code{character}, the results file (must be of type *_.slf). If \code{NULL}
(default), the information from the existing steering file will be used or
(if the file does not yet exist) will be extracted from \code{x$res}.}

\item{vars}{Selection of variables to be imported after the simulation: either \code{"all"}
(default) reading all variables, \code{"none"} giving only the header, a character
vector of variable names, or a numeric vector of positions. Importing all variables
may require large storage capacities (depending on the number of variables, mesh points,
and specified output intervals).}

\item{exec}{\code{character}, the TELEMAC-2D executable if not already specified in
\code{x}.}
}
\value{
An object of class \code{t2d} with new or updated element \code{res}
(an object of class \code{t2d_res}).
}
\description{
Conduct a TELEMAC-2D model run using the model's system command.
}
\note{
In case the project directory or any of the mandatory input files do not yet exist,
this function will first call \code{\link{write_t2d}} and then run the model.

TELEMAC-2D runs are often rather long. During simulation time this command will,
by default, write nothing to console but store the output in the specified log file.

In case of large projects with expected long model runtimes it might make
more sense to run TELEMAC-2D directly instead of using this function.
}
